/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.connect;

import com.ibm.hwmca.fw.servlet.connect.ConnectClient;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.pmod.task.TaskEndedException;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.servlet.util.WindowOptions;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.ui.UIStyle;
import com.ibm.hwmca.fw.ui.UIStyleManager;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Connect
extends HttpServlet {
    private static final String TRACE_MASKT = "XUCNSRVT";
    private static final String TRACE_MASKF = "XUCNSRVF";
    private static final String CONNECT_TASK_CLASS = "com.ibm.hwmca.fw.servlet.connect.ConnectTask";
    private static final String CHANGEPW_TASK_CLASS = "com.ibm.hwmca.fw.changepw.ChangePWTask";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletRuntime.getRuntime().attachUserContextToServletThread(req);
        hmcSession = HMCSession.getHMCSession(req.getSession());
        if (Connect.isConnected(hmcSession)) {
            this.openWindowWithUI(req, resp, (String)hmcSession.getSessionAttribute("connect.uiURL"));
            return;
        }
        availableScreenSize = req.getParameter("availableScreenSize");
        if (availableScreenSize != null) {
            comma = availableScreenSize.indexOf(44);
            if (comma != -1 && comma > 0 && comma < availableScreenSize.length() - 1) {
                try {
                    availableScreenWidth = Integer.parseInt(availableScreenSize.substring(0, comma));
                    availableScreenHeight = Integer.parseInt(availableScreenSize.substring(comma + 1));
                    Trace.trace("XUCNSRVF", "Available pixels on client screen:  width==" + availableScreenWidth + " height==" + availableScreenHeight);
                    hmcSession.setAvailableScreenWidth(availableScreenWidth);
                    hmcSession.setAvailableScreenHeight(availableScreenHeight);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            time = req.getParameter("time");
            timeString = req.getParameter("timeString");
            usesDST = req.getParameter("usesDST");
            tzOffset = req.getParameter("tzOffset");
            timeZone = ServletRuntime.getRuntime().calculateTimeZone(time, timeString, usesDST, tzOffset);
            if (timeZone != null) {
                userContext = hmcSession.getUserContext();
                userContext.setTimeZone(timeZone);
                try {
                    userContext.getConnectionFactory().updateUserContext(userContext);
                }
                catch (Exception e) {
                    Trace.trace("XUCNSRVT", "Exception updating UserContext:");
                    Trace.trace("XUCNSRVT", e);
                }
            }
        }
        if (!this.isClientInformationKnown(hmcSession)) {
            reqparms = new StringBuffer();
            iterator = req.getParameterMap().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (entry.getKey().equals("availableScreenSize") || entry.getKey().equals("tzOffset") || entry.getKey().equals("time") || entry.getKey().equals("timeString") || entry.getKey().equals("usesDST")) continue;
                reqparms.append(entry.getKey());
                reqparms.append('=');
                try {
                    reqparms.append(URLEncoder.encode(((String[])entry.getValue())[0], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                reqparms.append('&');
            }
            req.setAttribute("reqparms", (Object)reqparms);
            Trace.trace("XUCNSRVF", "Dispatching connect request to fetchClientInfo.jsp");
            req.getRequestDispatcher("/connects/fetchClientInfo.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        user = hmcSession.getUserContext().getUserName();
        changedpw = req.getParameter("changedpw");
        if (changedpw != null && changedpw.equals("no")) {
            hmcSession.disconnectFromWebSession();
            hmcSession.destroy();
            req.getSession().invalidate();
            resp.sendRedirect("/");
            return;
        }
        connectClient = null;
        try {
            connectClient = new ConnectClient();
            if (this.isPasswordExpired(req, resp, hmcSession, connectClient, user)) {
                var16_25 = null;
                if (connectClient != null) {
                    connectClient.dispose();
                }
                return;
            }
            disconnectedSessions = HMCSession.getDisconnectedSessions(user);
            if (!disconnectedSessions.isEmpty()) break block27;
            this.startNewSession(hmcSession, connectClient, user, req, resp);
        }
        catch (Throwable var15_34) {
            var16_33 = null;
            if (connectClient != null) {
                connectClient.dispose();
            }
            throw var15_34;
        }
        var16_26 = null;
        if (connectClient == null) ** GOTO lbl-1000
        connectClient.dispose();
lbl-1000:
        // 2 sources

        {
            block27: {
                return;
            }
            sessionId = req.getParameter("session");
            if (sessionId == null) break block28;
            if (!sessionId.equals("new")) break block29;
            this.startNewSession(hmcSession, connectClient, user, req, resp);
        }
        var16_27 = null;
        if (connectClient == null) ** GOTO lbl-1000
        connectClient.dispose();
lbl-1000:
        // 2 sources

        {
            block29: {
                return;
            }
            if (!sessionId.equals("cancel")) break block30;
            hmcSession.disconnectFromWebSession();
            hmcSession.destroy();
            req.getSession().invalidate();
            resp.sendRedirect("/");
        }
        var16_28 = null;
        if (connectClient == null) ** GOTO lbl-1000
        connectClient.dispose();
lbl-1000:
        // 2 sources

        {
            block30: {
                return;
            }
            chosenSession = null;
            iterator = disconnectedSessions.iterator();
            while (chosenSession == null && iterator.hasNext()) {
                candidateSession = (HMCSession)iterator.next();
                if (!candidateSession.getSessionId().equals(sessionId)) continue;
                chosenSession = candidateSession;
            }
            if (chosenSession == null) break block28;
            Trace.trace("XUCNSRVT", "Destroying HMC session \"" + hmcSession.getSessionId() + "\" and reconnecting to \"" + sessionId + '\"');
            hmcSession.disconnectFromWebSession();
            chosenSession.connectToWebSession(req.getSession());
            chosenSession.setAvailableScreenWidth(hmcSession.getAvailableScreenWidth());
            chosenSession.setAvailableScreenHeight(hmcSession.getAvailableScreenHeight());
            hmcSession.destroy();
            clientContext = chosenSession.getUserContext();
            ServletRuntime.getRuntime().updateUserContext(clientContext, req);
            Trace.trace("XUCNSRVT", "Updating the user context in HMC session.  Client address is now " + clientContext.getAddress());
            this.openWindowWithUI(req, resp, (String)chosenSession.getSessionAttribute("connect.uiURL"));
        }
        var16_29 = null;
        if (connectClient == null) ** GOTO lbl-1000
        connectClient.dispose();
lbl-1000:
        // 2 sources

        {
            block28: {
                return;
                catch (IllegalStateException e) {
                    hmcSession.connectToWebSession(req.getSession());
                }
            }
            Trace.trace("XUCNSRVT", "Starting ConnectTask to have user choose a disconnected session.");
            parms = new PresentationTaskParms();
            task = TaskLauncher.startTask(parms, "com.ibm.hwmca.fw.servlet.connect.ConnectTask", hmcSession, false);
            portal = task.getPanelModelTaskPortal();
            Trace.trace("XUCNSRVT", "Connect servlet waiting for ConnectTask to prepare first panel.");
            portal.waitForPanel();
            if (!portal.isTaskEnded()) break block26;
            Trace.trace("XUCNSRVT", "ConnectTask ended without showing a panel.");
            this.startNewSession(hmcSession, connectClient, user, req, resp);
        }
        var16_30 = null;
        if (connectClient == null) ** GOTO lbl-1000
        connectClient.dispose();
lbl-1000:
        // 2 sources

        {
            block26: {
                return;
            }
            Trace.trace("XUCNSRVT", "Connect servlet redirecting to Task Interface for task id == " + task.getTaskId());
            resp.sendRedirect(resp.encodeRedirectURL(ServletRuntime.getRuntime().getHMCContextPath() + "/content?taskId=" + task.getTaskId()));
        }
        var16_31 = null;
        if (connectClient == null) ** GOTO lbl-1000
        connectClient.dispose();
lbl-1000:
        // 2 sources

        {
            return;
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace("XUCNSRVT", "Exception running ConnectTask to choose disconnected session.");
                Trace.trace("XUCNSRVT", e);
                this.startNewSession(hmcSession, connectClient, user, req, resp);
                var16_32 = null;
                if (connectClient != null) {
                    connectClient.dispose();
                }
            }
        }
    }

    private void startNewSession(HMCSession hmcSession, ConnectClient connectClient, String user, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "Starting a new session for user \"" + user + "\".");
        UIStyle uiStyle = null;
        String chosenUI = req.getParameter("ui");
        if (chosenUI != null) {
            Iterator iterator = UIStyleManager.getUIStyleManager().getUIStyles().iterator();
            while (uiStyle == null && iterator.hasNext()) {
                UIStyle candidateStyle = (UIStyle)iterator.next();
                if (!candidateStyle.getIdentifier().equalsIgnoreCase(chosenUI)) continue;
                uiStyle = candidateStyle;
            }
        }
        if (uiStyle == null && (uiStyle = connectClient.getUIStyleForUser(user)) == null) {
            throw new ServletException("Unable to determine UI style to use");
        }
        String uiURL = ServletRuntime.getRuntime().getHMCContextPath() + uiStyle.getInitialURI();
        hmcSession.setSessionAttribute("connect.uiURL", uiURL);
        this.openWindowWithUI(req, resp, uiURL);
        hmcSession.setSessionAttribute("connect.connected", "true");
    }

    private void openWindowWithUI(HttpServletRequest req, HttpServletResponse resp, String url) throws ServletException, IOException {
        String option;
        req.setAttribute("uiURL", (Object)url);
        HMCSession hmcSession = HMCSession.getHMCSession(req.getSession());
        Collection taskIdColl = hmcSession.getRunningTasks();
        if (!taskIdColl.isEmpty()) {
            ArrayList taskIds = new ArrayList(taskIdColl);
            Collections.sort(taskIds, new Comparator(){

                public int compare(Object o1, Object o2) {
                    PanelModelTaskPortal p1 = (PanelModelTaskPortal)o1;
                    PanelModelTaskPortal p2 = (PanelModelTaskPortal)o2;
                    return (int)(p1.getPresentationTask().getTaskId() - p2.getPresentationTask().getTaskId());
                }
            });
            ArrayList<String> windowNames = new ArrayList<String>(taskIds.size());
            ArrayList<String> windowURIs = new ArrayList<String>(taskIds.size());
            ArrayList<String> windowOptions = new ArrayList<String>(taskIds.size());
            Iterator iterator = taskIds.iterator();
            while (iterator.hasNext()) {
                PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
                try {
                    if (portal.isPanelStackEmpty()) continue;
                    windowNames.add(portal.getWindowName());
                    windowURIs.add(TaskControllerQueue.getUrl(portal));
                    WindowOptions winOpts = (WindowOptions)TaskControllerQueue.getWindowOptionsForTask(portal).clone();
                    windowOptions.add(winOpts.toString());
                    portal.setWindowOpen(true);
                }
                catch (TaskEndedException e) {
                    // empty catch block
                }
            }
            Trace.trace(TRACE_MASKF, "Reconnect processing will open " + windowNames.size() + " task windows.");
            if (!windowNames.isEmpty()) {
                req.setAttribute("windowNames", windowNames);
                req.setAttribute("windowURIs", windowURIs);
                req.setAttribute("windowOptions", windowOptions);
            }
        }
        if ((option = req.getParameter("option")) != null && option.equalsIgnoreCase("closeWindow")) {
            req.setAttribute("closeWindow", (Object)"true");
        }
        Trace.trace(TRACE_MASKF, "Dispatching connect request to newSession.jsp");
        req.getRequestDispatcher("/connects/newSession.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    public static boolean isConnected(HMCSession hmcSession) {
        return hmcSession.getSessionAttribute("connect.connected") != null;
    }

    private boolean isClientInformationKnown(HMCSession hmcSession) {
        return hmcSession.getAvailableScreenWidth() != -1;
    }

    private boolean isPasswordExpired(HttpServletRequest req, HttpServletResponse resp, HMCSession hmcSession, ConnectClient connectClient, String userid) {
        if (!connectClient.isPasswordExpired(userid)) {
            return false;
        }
        Trace.trace(TRACE_MASKT, "Starting ChangePWTask to have user change their expired password.");
        try {
            PresentationTaskParms parms = new PresentationTaskParms();
            parms.setData("mode", "forced");
            PresentationTask task = TaskLauncher.startTask(parms, CHANGEPW_TASK_CLASS, hmcSession, false);
            PanelModelTaskPortal portal = task.getPanelModelTaskPortal();
            Trace.trace(TRACE_MASKT, "Connect servlet waiting for ChangePWTask to prepare first panel.");
            portal.waitForPanel();
            if (portal.isTaskEnded()) {
                Trace.trace(TRACE_MASKT, "ChangePWTask ended without showing a panel.");
                return false;
            }
            Trace.trace(TRACE_MASKT, "Connect servlet redirecting to Task Interface for task id == " + task.getTaskId());
            resp.sendRedirect(resp.encodeRedirectURL(ServletRuntime.getRuntime().getHMCContextPath() + "/content?taskId=" + task.getTaskId()));
            return true;
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            Trace.trace(TRACE_MASKT, "Exception running ChangePWTask to change expired password.");
            Trace.trace(TRACE_MASKT, e);
            return false;
        }
    }

    private void initializeWebApplication(HttpServletRequest req) {
        ServletRuntime.getRuntime().setHMCContextPath(req.getContextPath());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void init() throws ServletException {
        ServletRuntime.getRuntime().setServletOptions(this.getServletContext());
        Trace.trace(TRACE_MASKF, "Finished Initializing");
    }
}

